﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/greengrass/GreengrassRequest.h>
#include <aws/greengrass/Greengrass_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Greengrass {
namespace Model {

/**
 */
class UpdateSubscriptionDefinitionRequest : public GreengrassRequest {
 public:
  AWS_GREENGRASS_API UpdateSubscriptionDefinitionRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "UpdateSubscriptionDefinition"; }

  AWS_GREENGRASS_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * The name of the definition.
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  UpdateSubscriptionDefinitionRequest& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * The ID of the subscription definition.
   */
  inline const Aws::String& GetSubscriptionDefinitionId() const { return m_subscriptionDefinitionId; }
  inline bool SubscriptionDefinitionIdHasBeenSet() const { return m_subscriptionDefinitionIdHasBeenSet; }
  template <typename SubscriptionDefinitionIdT = Aws::String>
  void SetSubscriptionDefinitionId(SubscriptionDefinitionIdT&& value) {
    m_subscriptionDefinitionIdHasBeenSet = true;
    m_subscriptionDefinitionId = std::forward<SubscriptionDefinitionIdT>(value);
  }
  template <typename SubscriptionDefinitionIdT = Aws::String>
  UpdateSubscriptionDefinitionRequest& WithSubscriptionDefinitionId(SubscriptionDefinitionIdT&& value) {
    SetSubscriptionDefinitionId(std::forward<SubscriptionDefinitionIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  Aws::String m_subscriptionDefinitionId;
  bool m_subscriptionDefinitionIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Greengrass
}  // namespace Aws
