﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSStreamFwd.h>
#include <aws/ec2/EC2_EXPORTS.h>

namespace Aws {
namespace Utils {
namespace Xml {
class XmlNode;
}  // namespace Xml
}  // namespace Utils
namespace EC2 {
namespace Model {

/**
 * <p>Describes the port range for a Verified Access endpoint.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyVerifiedAccessEndpointPortRange">AWS
 * API Reference</a></p>
 */
class ModifyVerifiedAccessEndpointPortRange {
 public:
  AWS_EC2_API ModifyVerifiedAccessEndpointPortRange() = default;
  AWS_EC2_API ModifyVerifiedAccessEndpointPortRange(const Aws::Utils::Xml::XmlNode& xmlNode);
  AWS_EC2_API ModifyVerifiedAccessEndpointPortRange& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

  AWS_EC2_API void OutputToStream(Aws::OStream& ostream, const char* location, unsigned index, const char* locationValue) const;
  AWS_EC2_API void OutputToStream(Aws::OStream& oStream, const char* location) const;

  ///@{
  /**
   * <p>The start of the port range.</p>
   */
  inline int GetFromPort() const { return m_fromPort; }
  inline bool FromPortHasBeenSet() const { return m_fromPortHasBeenSet; }
  inline void SetFromPort(int value) {
    m_fromPortHasBeenSet = true;
    m_fromPort = value;
  }
  inline ModifyVerifiedAccessEndpointPortRange& WithFromPort(int value) {
    SetFromPort(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The end of the port range.</p>
   */
  inline int GetToPort() const { return m_toPort; }
  inline bool ToPortHasBeenSet() const { return m_toPortHasBeenSet; }
  inline void SetToPort(int value) {
    m_toPortHasBeenSet = true;
    m_toPort = value;
  }
  inline ModifyVerifiedAccessEndpointPortRange& WithToPort(int value) {
    SetToPort(value);
    return *this;
  }
  ///@}
 private:
  int m_fromPort{0};

  int m_toPort{0};
  bool m_fromPortHasBeenSet = false;
  bool m_toPortHasBeenSet = false;
};

}  // namespace Model
}  // namespace EC2
}  // namespace Aws
