-- SPDX-License-Identifier: GPL-3.0-or-later
log_target('syslog') -- assume running as OS service

local ffi = require('ffi')
local id = os.getenv('SYSTEMD_INSTANCE')
if not id then
	log_warn(ffi.C.LOG_GRP_SYSTEM, 'environment variable $SYSTEMD_INSTANCE not set')
else
	-- Bind to control socket in run_dir
	worker.control_path = '/run/knot-resolver/control/'
	local path = worker.control_path..id
	local ok, err = pcall(net.listen, path, nil, { kind = 'control' })
	if not ok then
		log_warn(ffi.C.LOG_GRP_NETWORK, 'bind to '..path..' failed '..err)
	end
end

-- Set cache location
rawset(cache, 'current_storage', 'lmdb:///var/cache/knot-resolver')
