/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.executors;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScorerSupplier;
import org.opensearch.neuralsearch.executors.HybridQueryExecutorCollector;
import org.opensearch.neuralsearch.executors.HybridQueryExecutorCollectorManager;

public final class HybridQueryScoreSupplierCollectorManager
implements HybridQueryExecutorCollectorManager<HybridQueryExecutorCollector<LeafReaderContext, ScorerSupplier>> {
    @NonNull
    private LeafReaderContext context;

    @Override
    public HybridQueryExecutorCollector<LeafReaderContext, ScorerSupplier> newCollector() {
        return HybridQueryExecutorCollector.newCollector(this.context);
    }

    public List<ScorerSupplier> mergeScoreSuppliers(List<HybridQueryExecutorCollector<LeafReaderContext, ScorerSupplier>> collectors) {
        ArrayList<ScorerSupplier> scorerSuppliers = new ArrayList<ScorerSupplier>();
        for (HybridQueryExecutorCollector<LeafReaderContext, ScorerSupplier> collector : collectors) {
            Optional<ScorerSupplier> result = collector.getResult();
            if (result.isPresent()) {
                scorerSuppliers.add(result.get());
                continue;
            }
            scorerSuppliers.add(null);
        }
        return scorerSuppliers;
    }

    @Generated
    public HybridQueryScoreSupplierCollectorManager(@NonNull LeafReaderContext context) {
        Objects.requireNonNull(context, "context is marked non-null but is null");
        this.context = context;
    }
}

