/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.json.UnionDeserializer;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

@JsonpDeserializable
public class FieldDateMath
implements TaggedUnion<Kind, Object>,
PlainJsonSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<FieldDateMath> _DESERIALIZER = JsonpDeserializer.lazy(FieldDateMath::buildFieldDateMathDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private FieldDateMath(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    private FieldDateMath(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static FieldDateMath of(Function<Builder, ObjectBuilder<FieldDateMath>> fn) {
        return fn.apply(new Builder()).build();
    }

    public String _toJsonString() {
        switch (this._kind.ordinal()) {
            case 0: {
                return this.expr();
            }
            case 1: {
                return String.valueOf(this.value());
            }
        }
        throw new IllegalStateException("Unknown kind " + (Object)((Object)this._kind));
    }

    public boolean isExpr() {
        return this._kind == Kind.Expr;
    }

    public String expr() {
        return (String)TaggedUnionUtils.get(this, Kind.Expr);
    }

    public boolean isValue() {
        return this._kind == Kind.Value;
    }

    public Double value() {
        return (Double)TaggedUnionUtils.get(this, Kind.Value);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind.ordinal()) {
                case 0: {
                    generator.write((String)this._value);
                    break;
                }
                case 1: {
                    generator.write(((Double)this._value).doubleValue());
                }
            }
        }
    }

    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    private static JsonpDeserializer<FieldDateMath> buildFieldDateMathDeserializer() {
        return new UnionDeserializer.Builder<FieldDateMath, Kind, Object>(FieldDateMath::new, false).addMember(Kind.Expr, JsonpDeserializer.stringDeserializer()).addMember(Kind.Value, JsonpDeserializer.doubleDeserializer()).build();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode((Object)this._kind);
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldDateMath other = (FieldDateMath)o;
        return Objects.equals((Object)this._kind, (Object)other._kind) && Objects.equals(this._value, other._value);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<FieldDateMath> {
        private Kind _kind;
        private Object _value;

        public Builder() {
        }

        private Builder(FieldDateMath o) {
            this._kind = o._kind;
            this._value = o._value;
        }

        public ObjectBuilder<FieldDateMath> expr(String v) {
            this._kind = Kind.Expr;
            this._value = v;
            return this;
        }

        public ObjectBuilder<FieldDateMath> value(Double v) {
            this._kind = Kind.Value;
            this._value = v;
            return this;
        }

        @Override
        public FieldDateMath build() {
            this._checkSingleUse();
            return new FieldDateMath(this);
        }
    }

    public static enum Kind {
        Expr,
        Value;

    }
}

