/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.monitor;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.listener.WeakEventListener;
import org.assertj.swing.monitor.Windows;

final class WindowAvailabilityMonitor
implements AWTEventListener {
    private static final long EVENT_MASK = 8240L;
    private final Windows windows;

    WindowAvailabilityMonitor(@Nonnull Windows windows) {
        this.windows = windows;
    }

    void attachTo(@Nonnull Toolkit toolkit) {
        WeakEventListener.attachAsWeakEventListener(toolkit, this, 8240L);
    }

    @Override
    @RunsInEDT
    public void eventDispatched(AWTEvent e) {
        if (!(e instanceof MouseEvent)) {
            return;
        }
        Object source = e.getSource();
        if (!(source instanceof Component)) {
            return;
        }
        Component c = (Component)source;
        Window w = c instanceof Window ? (Window)c : SwingUtilities.getWindowAncestor(c);
        this.windows.markAsReady(w);
    }
}

