/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThrowableConsumer;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.SystemIndependent;

public final class VcsFileUtil {
    public static final int FILE_PATH_LIMIT = 7600;

    public static void foreachChunk(@NotNull List<String> arguments, int groupSize, @NotNull ThrowableConsumer<? super List<String>, ? extends VcsException> consumer) throws VcsException {
        if (arguments == null) {
            VcsFileUtil.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            VcsFileUtil.$$$reportNull$$$0(1);
        }
        List<List<String>> chunks = VcsFileUtil.chunkArguments(arguments, groupSize);
        for (List<String> chunk : chunks) {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null) {
                indicator.checkCanceled();
            }
            consumer.consume(chunk);
        }
    }

    @NotNull
    public static List<List<String>> chunkArguments(@NotNull List<String> arguments) {
        if (arguments == null) {
            VcsFileUtil.$$$reportNull$$$0(2);
        }
        return VcsFileUtil.chunkArguments(arguments, 1);
    }

    @NotNull
    public static List<List<String>> chunkArguments(@NotNull List<String> arguments, int groupSize) {
        int i;
        if (arguments == null) {
            VcsFileUtil.$$$reportNull$$$0(3);
        }
        assert (arguments.size() % groupSize == 0) : "Arguments size should be divisible by group size";
        ArrayList<List<String>> rc = new ArrayList<List<String>>();
        int start2 = 0;
        int size = 0;
        for (i = 0; i < arguments.size(); i += groupSize) {
            int length = 0;
            for (int j = 0; j < groupSize; ++j) {
                length += arguments.get(i + j).length();
            }
            if (size + length > 7600) {
                if (start2 == i) {
                    rc.add(arguments.subList(i, i + groupSize));
                    start2 = i + groupSize;
                    size = 0;
                    continue;
                }
                rc.add(arguments.subList(start2, i));
                start2 = i;
                size = length;
                continue;
            }
            size += length;
        }
        if (start2 != arguments.size()) {
            rc.add(arguments.subList(start2, i));
        }
        ArrayList<List<String>> arrayList = rc;
        if (arrayList == null) {
            VcsFileUtil.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    public static List<List<String>> chunkPaths(VirtualFile root, Collection<? extends FilePath> files) {
        return VcsFileUtil.chunkArguments(VcsFileUtil.toRelativePaths(root, files));
    }

    public static List<List<String>> chunkFiles(@NotNull VirtualFile root, @NotNull Collection<? extends VirtualFile> files) {
        if (root == null) {
            VcsFileUtil.$$$reportNull$$$0(5);
        }
        if (files == null) {
            VcsFileUtil.$$$reportNull$$$0(6);
        }
        return VcsFileUtil.chunkArguments(VcsFileUtil.toRelativeFiles(root, files));
    }

    public static String getRelativeFilePath(VirtualFile file, @NotNull VirtualFile baseDir) {
        if (baseDir == null) {
            VcsFileUtil.$$$reportNull$$$0(7);
        }
        return VcsFileUtil.getRelativeFilePath(file.getPath(), baseDir);
    }

    public static String getRelativeFilePath(String file, @NotNull VirtualFile baseDir) {
        String basePath;
        if (baseDir == null) {
            VcsFileUtil.$$$reportNull$$$0(8);
        }
        if (SystemInfo.isWindows) {
            file = file.replace('\\', '/');
        }
        if (!file.startsWith(basePath = baseDir.getPath())) {
            return file;
        }
        if (file.equals(basePath)) {
            return ".";
        }
        return file.substring(baseDir.getPath().length() + 1);
    }

    public static boolean isOctal(char ch) {
        return '0' <= ch && ch <= '7';
    }

    public static String relativePath(VirtualFile root, FilePath path) {
        return VcsFileUtil.relativePath(VfsUtilCore.virtualToIoFile((VirtualFile)root), path.getIOFile());
    }

    public static String relativePath(File root, FilePath path) {
        return VcsFileUtil.relativePath(root, path.getIOFile());
    }

    public static String relativePath(File root, VirtualFile file) {
        return VcsFileUtil.relativePath(root, VfsUtilCore.virtualToIoFile((VirtualFile)file));
    }

    public static String relativePath(VirtualFile root, VirtualFile file) {
        return VcsFileUtil.relativePath(VfsUtilCore.virtualToIoFile((VirtualFile)root), VfsUtilCore.virtualToIoFile((VirtualFile)file));
    }

    public static String relativeOrFullPath(VirtualFile root, VirtualFile file) {
        if (root == null) {
            file.getPath();
        }
        return VcsFileUtil.relativePath(VfsUtilCore.virtualToIoFile((VirtualFile)root), VfsUtilCore.virtualToIoFile((VirtualFile)file));
    }

    @NotNull
    public static String relativePath(@NotNull FilePath root, @NotNull FilePath file) {
        if (root == null) {
            VcsFileUtil.$$$reportNull$$$0(9);
        }
        if (file == null) {
            VcsFileUtil.$$$reportNull$$$0(10);
        }
        String string = VcsFileUtil.relativePath(root.getIOFile(), file.getIOFile());
        if (string == null) {
            VcsFileUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    public static String relativePath(File root, File path) {
        String rc = FileUtil.getRelativePath((File)root, (File)path);
        if (rc == null) {
            throw new IllegalArgumentException("The file " + String.valueOf(path) + " cannot be made relative to " + String.valueOf(root));
        }
        return rc.replace(File.separatorChar, '/');
    }

    public static List<String> toRelativePaths(@NotNull VirtualFile root, @NotNull Collection<? extends FilePath> filePaths) {
        if (root == null) {
            VcsFileUtil.$$$reportNull$$$0(12);
        }
        if (filePaths == null) {
            VcsFileUtil.$$$reportNull$$$0(13);
        }
        ArrayList<String> rc = new ArrayList<String>(filePaths.size());
        for (FilePath filePath : filePaths) {
            rc.add(VcsFileUtil.relativePath(root, filePath));
        }
        return rc;
    }

    public static List<String> toRelativeFiles(@NotNull VirtualFile root, @NotNull Collection<? extends VirtualFile> files) {
        if (root == null) {
            VcsFileUtil.$$$reportNull$$$0(14);
        }
        if (files == null) {
            VcsFileUtil.$$$reportNull$$$0(15);
        }
        ArrayList<String> rc = new ArrayList<String>(files.size());
        for (VirtualFile virtualFile : files) {
            rc.add(VcsFileUtil.relativePath(root, virtualFile));
        }
        return rc;
    }

    public static void markFilesDirty(@NotNull Project project, @NotNull Collection<? extends VirtualFile> affectedFiles) {
        if (project == null) {
            VcsFileUtil.$$$reportNull$$$0(16);
        }
        if (affectedFiles == null) {
            VcsFileUtil.$$$reportNull$$$0(17);
        }
        VcsDirtyScopeManager dirty = VcsDirtyScopeManager.getInstance((Project)project);
        for (VirtualFile virtualFile : affectedFiles) {
            if (virtualFile.isDirectory()) {
                dirty.dirDirtyRecursively(virtualFile);
                continue;
            }
            dirty.fileDirty(virtualFile);
        }
    }

    public static void markFilesDirty(@NotNull Project project, @NotNull List<? extends FilePath> affectedFiles) {
        if (project == null) {
            VcsFileUtil.$$$reportNull$$$0(18);
        }
        if (affectedFiles == null) {
            VcsFileUtil.$$$reportNull$$$0(19);
        }
        VcsDirtyScopeManager dirty = VcsDirtyScopeManager.getInstance((Project)project);
        for (FilePath filePath : affectedFiles) {
            if (filePath.isDirectory()) {
                dirty.dirDirtyRecursively(filePath);
                continue;
            }
            dirty.fileDirty(filePath);
        }
    }

    public static void addFilesToVcsWithConfirmation(@NotNull Project project, VirtualFile ... virtualFiles) {
        if (project == null) {
            VcsFileUtil.$$$reportNull$$$0(20);
        }
        VcsFileUtil.addFilesToVcsWithConfirmation(project, Arrays.asList(virtualFiles));
    }

    public static void addFilesToVcsWithConfirmation(@NotNull Project project, @NotNull Collection<? extends VirtualFile> virtualFiles) {
        if (project == null) {
            VcsFileUtil.$$$reportNull$$$0(21);
        }
        if (virtualFiles == null) {
            VcsFileUtil.$$$reportNull$$$0(22);
        }
        if (virtualFiles.isEmpty()) {
            return;
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        ArrayListMultimap vcsMap = ArrayListMultimap.create();
        for (VirtualFile virtualFile : virtualFiles) {
            AbstractVcs vcs = vcsManager.getVcsFor(virtualFile);
            if (vcs == null) continue;
            VfsUtil.processFileRecursivelyWithoutIgnored((VirtualFile)virtualFile, arg_0 -> VcsFileUtil.lambda$addFilesToVcsWithConfirmation$0((Multimap)vcsMap, vcs, arg_0));
        }
        for (AbstractVcs abstractVcs : vcsMap.keySet()) {
            VcsShowConfirmationOption addOption = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, abstractVcs);
            if (addOption.getValue() == VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
                return;
            }
            ArrayList filesList = new ArrayList(vcsMap.get((Object)abstractVcs));
            if (addOption.getValue() == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY) {
                VcsFileUtil.performAdditions(abstractVcs, filesList);
                continue;
            }
            AbstractVcsHelper helper = AbstractVcsHelper.getInstance((Project)project);
            Ref filesToAdd = Ref.create();
            ApplicationManager.getApplication().invokeAndWait(() -> filesToAdd.set((Object)helper.selectFilesToProcess(new ArrayList(filesList), VcsBundle.message((String)"confirmation.title.add.files.to", (Object[])new Object[]{vcs.getDisplayName()}), null, VcsBundle.message((String)"confirmation.title.add.file.to", (Object[])new Object[]{vcs.getDisplayName()}), null, addOption)));
            if (filesToAdd.isNull()) continue;
            VcsFileUtil.performAdditions(abstractVcs, new ArrayList((Collection)filesToAdd.get()));
        }
    }

    private static void performAdditions(@NotNull AbstractVcs vcs, @NotNull List<? extends VirtualFile> value) {
        CheckinEnvironment checkinEnvironment;
        if (vcs == null) {
            VcsFileUtil.$$$reportNull$$$0(23);
        }
        if (value == null) {
            VcsFileUtil.$$$reportNull$$$0(24);
        }
        if ((checkinEnvironment = vcs.getCheckinEnvironment()) != null) {
            checkinEnvironment.scheduleUnversionedFilesForAddition(value);
        }
    }

    public static boolean isAncestor(@NotNull @SystemIndependent String ancestor, @NotNull @SystemIndependent String path, boolean strict) {
        if (ancestor == null) {
            VcsFileUtil.$$$reportNull$$$0(25);
        }
        if (path == null) {
            VcsFileUtil.$$$reportNull$$$0(26);
        }
        return FileUtil.startsWith((String)path, (String)ancestor, (boolean)SystemInfo.isFileSystemCaseSensitive, (boolean)strict);
    }

    public static boolean isAncestor(@NotNull FilePath ancestor, @NotNull FilePath path, boolean strict) {
        if (ancestor == null) {
            VcsFileUtil.$$$reportNull$$$0(27);
        }
        if (path == null) {
            VcsFileUtil.$$$reportNull$$$0(28);
        }
        return VcsFileUtil.isAncestor(ancestor.getPath(), path.getPath(), strict);
    }

    public static boolean isAncestor(@NotNull VirtualFile root, @NotNull FilePath path) {
        if (root == null) {
            VcsFileUtil.$$$reportNull$$$0(29);
        }
        if (path == null) {
            VcsFileUtil.$$$reportNull$$$0(30);
        }
        return VcsFileUtil.isAncestor(root.getPath(), path.getPath(), false);
    }

    @NotNull
    public static String unescapeGitPath(@NotNull String path) throws IllegalArgumentException {
        if (path == null) {
            VcsFileUtil.$$$reportNull$$$0(31);
        }
        String QUOTE = "\"";
        if (path.startsWith("\"") && path.endsWith("\"")) {
            path = path.substring(1, path.length() - 1);
        }
        if (path.indexOf(92) == -1) {
            String string = path;
            if (string == null) {
                VcsFileUtil.$$$reportNull$$$0(32);
            }
            return string;
        }
        Charset encoding = Charset.defaultCharset();
        int l = path.length();
        StringBuilder rc = new StringBuilder(l);
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '\\') {
                if (++i >= l) {
                    throw new IllegalArgumentException("Unterminated escape sequence in the path: " + path);
                }
                char e = path.charAt(i);
                switch (e) {
                    case '\\': {
                        rc.append('\\');
                        break;
                    }
                    case 't': {
                        rc.append('\t');
                        break;
                    }
                    case 'n': {
                        rc.append('\n');
                        break;
                    }
                    case 'r': {
                        rc.append('\r');
                        break;
                    }
                    case 'a': {
                        rc.append('\u0007');
                        break;
                    }
                    case 'b': {
                        rc.append('\b');
                        break;
                    }
                    case 'f': {
                        rc.append('\f');
                        break;
                    }
                    case '\"': {
                        rc.append('\"');
                        break;
                    }
                    default: {
                        if (VcsFileUtil.isOctal(e)) {
                            int n = 0;
                            for (int j = i; j < l; ++j) {
                                if (VcsFileUtil.isOctal(path.charAt(j))) {
                                    ++n;
                                    for (int k = 0; k < 3 && j < l && VcsFileUtil.isOctal(path.charAt(j)); ++j, ++k) {
                                    }
                                }
                                if (j + 1 >= l || path.charAt(j) != '\\' || !VcsFileUtil.isOctal(path.charAt(j + 1))) break;
                            }
                            byte[] b = new byte[n];
                            n = 0;
                            while (i < l) {
                                if (VcsFileUtil.isOctal(path.charAt(i))) {
                                    int code = 0;
                                    for (int k = 0; k < 3 && i < l && VcsFileUtil.isOctal(path.charAt(i)); ++i, ++k) {
                                        code = code * 8 + (path.charAt(i) - 48);
                                    }
                                    b[n++] = (byte)code;
                                }
                                if (i + 1 >= l || path.charAt(i) != '\\' || !VcsFileUtil.isOctal(path.charAt(i + 1))) break;
                                ++i;
                            }
                            --i;
                            assert (n == b.length);
                            rc.append(new String(b, encoding));
                            break;
                        }
                        throw new IllegalArgumentException("Unknown escape sequence '\\" + path.charAt(i) + "' in the path: " + path);
                    }
                }
                continue;
            }
            rc.append(c);
        }
        String string = rc.toString();
        if (string == null) {
            VcsFileUtil.$$$reportNull$$$0(33);
        }
        return string;
    }

    private static /* synthetic */ boolean lambda$addFilesToVcsWithConfirmation$0(Multimap vcsMap, AbstractVcs vcs, VirtualFile virtualFile) {
        return vcsMap.put((Object)vcs, (Object)virtualFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 11, 32, 33 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: 
            case 11: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcsUtil/VcsFileUtil";
                break;
            }
            case 5: 
            case 9: 
            case 12: 
            case 14: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedFiles";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 26: 
            case 28: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcsUtil/VcsFileUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "chunkArguments";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "relativePath";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeGitPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "foreachChunk";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "chunkArguments";
                break;
            }
            case 4: 
            case 11: 
            case 32: 
            case 33: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "chunkFiles";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeFilePath";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "relativePath";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "toRelativePaths";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "toRelativeFiles";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "markFilesDirty";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addFilesToVcsWithConfirmation";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "performAdditions";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "unescapeGitPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 11, 32, 33 -> new IllegalStateException(string);
        };
    }
}

