/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.platform.vcs.VcsUtil;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.vcs.log.Hash;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public final class HashImpl
implements Hash {
    private static final int BASE = 16;
    private final byte @NotNull [] myData;
    private final int myHashCode;

    @NotNull
    public static Hash build(@NotNull String inputStr) {
        if (inputStr == null) {
            HashImpl.$$$reportNull$$$0(0);
        }
        byte[] data = HashImpl.buildData(inputStr);
        assert (data.length > 0) : "Can not build hash for string " + inputStr;
        return new HashImpl(data);
    }

    @NotNull
    public static Hash read(@NotNull DataInput in) throws IOException {
        int length;
        if (in == null) {
            HashImpl.$$$reportNull$$$0(1);
        }
        if ((length = DataInputOutputUtil.readINT((DataInput)in)) == 0) {
            throw new IOException("Can not read hash: data length is zero");
        }
        byte[] buf = new byte[length];
        in.readFully(buf);
        return new HashImpl(buf);
    }

    public void write(@NotNull DataOutput out) throws IOException {
        if (out == null) {
            HashImpl.$$$reportNull$$$0(2);
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)this.myData.length);
        out.write(this.myData);
    }

    private static byte @NotNull [] buildData(@NotNull String inputStr) {
        if (inputStr == null) {
            HashImpl.$$$reportNull$$$0(3);
        }
        int length = inputStr.length();
        byte even = (byte)(length % 2);
        byte[] data = new byte[length / 2 + 1 + even];
        data[0] = even;
        for (int i = 0; i < length / 2; ++i) {
            int k = HashImpl.parseChar(inputStr, 2 * i) * 16 + HashImpl.parseChar(inputStr, 2 * i + 1);
            data[i + 1] = (byte)(k - 128);
        }
        if (even == 1) {
            int k = HashImpl.parseChar(inputStr, length - 1);
            data[length / 2 + 1] = (byte)(k - 128);
        }
        if (data == null) {
            HashImpl.$$$reportNull$$$0(4);
        }
        return data;
    }

    private static int parseChar(@NotNull String inputString, int index) {
        int k;
        if (inputString == null) {
            HashImpl.$$$reportNull$$$0(5);
        }
        if ((k = Character.digit(inputString.charAt(index), 16)) < 0) {
            throw new IllegalArgumentException("bad hash string: " + inputString);
        }
        return k;
    }

    private HashImpl(byte @NotNull [] hash) {
        if (hash == null) {
            HashImpl.$$$reportNull$$$0(6);
        }
        this.myData = hash;
        this.myHashCode = Arrays.hashCode(hash);
    }

    @NotNull
    public String asString() {
        assert (this.myData.length > 0) : "bad length Hash.data";
        byte even = this.myData[0];
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < this.myData.length; ++i) {
            int k1 = (this.myData[i] + 128) / 16;
            int k2 = (this.myData[i] + 128) % 16;
            char c1 = Character.forDigit(k1, 16);
            char c2 = Character.forDigit(k2, 16);
            if (i == this.myData.length - 1 && even == 1) {
                sb.append(c2);
                continue;
            }
            sb.append(c1).append(c2);
        }
        String string = sb.toString();
        if (string == null) {
            HashImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HashImpl that = (HashImpl)o;
        return this.myHashCode == that.myHashCode && Arrays.equals(this.myData, that.myData);
    }

    public int hashCode() {
        return this.myHashCode;
    }

    public String toString() {
        return this.asString();
    }

    @NotNull
    public String toShortString() {
        String string = VcsUtil.getShortHash((String)this.asString());
        if (string == null) {
            HashImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStr";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/impl/HashImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputString";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/impl/HashImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildData";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "asString";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toShortString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildData";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseChar";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7, 8 -> new IllegalStateException(string);
        };
    }
}

