\name{LaplacianRecursiveGaussianImageFilter}
\alias{LaplacianRecursiveGaussianImageFilter}
\title{LaplacianRecursiveGaussianImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Computes the Laplacian of Gaussian (LoG) of an image.
LaplacianRecursiveGaussianImageFilter}
\details{
Computes the Laplacian of Gaussian (LoG) of an image by convolution
with the second derivative of a Gaussian. This filter is implemented
using the recursive gaussian filters.
See:
LaplacianRecursiveGaussian for the procedural interface
itk::LaplacianRecursiveGaussianImageFilter for the Doxygen on the original ITK class.
LaplacianRecursiveGaussianImageFilter}
%C++ includes: sitkLaplacianRecursiveGaussianImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{std::string GetName() const:}{
Name of this class
}
\item{bool GetNormalizeAcrossScale() const:}{
Define which normalization factor will be used for the Gaussian
See:
RecursiveGaussianImageFilter::SetNormalizeAcrossScale
}
\item{double GetSigma() const:}{
Set/Get Sigma value. Sigma is measured in the units of image spacing.
}
\item{ LaplacianRecursiveGaussianImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self NormalizeAcrossScaleOff():}{}
\item{Self NormalizeAcrossScaleOn():}{
Set the value of NormalizeAcrossScale to true or false respectfully.
}
\item{Self SetNormalizeAcrossScale(bool NormalizeAcrossScale):}{
Define which normalization factor will be used for the Gaussian
See:
RecursiveGaussianImageFilter::SetNormalizeAcrossScale
}
\item{Self SetSigma(double Sigma):}{
Set/Get Sigma value. Sigma is measured in the units of image spacing.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~LaplacianRecursiveGaussianImageFilter():}{
Destructor
}
}
}
