/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.aggregations.MultiBucketBase;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class MultiTermsBucket
extends MultiBucketBase
implements ToCopyableBuilder<Builder, MultiTermsBucket> {
    @Nullable
    private final Long docCountErrorUpperBound;
    @Nonnull
    private final List<FieldValue> key;
    @Nullable
    private final String keyAsString;
    public static final JsonpDeserializer<MultiTermsBucket> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MultiTermsBucket::setupMultiTermsBucketDeserializer);

    private MultiTermsBucket(Builder builder) {
        super(builder);
        this.docCountErrorUpperBound = builder.docCountErrorUpperBound;
        this.key = ApiTypeHelper.unmodifiableRequired(builder.key, (Object)this, "key");
        this.keyAsString = builder.keyAsString;
    }

    public static MultiTermsBucket of(Function<Builder, ObjectBuilder<MultiTermsBucket>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long docCountErrorUpperBound() {
        return this.docCountErrorUpperBound;
    }

    @Nonnull
    public final List<FieldValue> key() {
        return this.key;
    }

    @Nullable
    public final String keyAsString() {
        return this.keyAsString;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.docCountErrorUpperBound != null) {
            generator.writeKey("doc_count_error_upper_bound");
            generator.write(this.docCountErrorUpperBound.longValue());
        }
        generator.writeKey("key");
        generator.writeStartArray();
        for (FieldValue item0 : this.key) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.keyAsString != null) {
            generator.writeKey("key_as_string");
            generator.write(this.keyAsString);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupMultiTermsBucketDeserializer(ObjectDeserializer<Builder> op) {
        MultiTermsBucket.setupMultiBucketBaseDeserializer(op);
        op.add(Builder::docCountErrorUpperBound, JsonpDeserializer.longDeserializer(), "doc_count_error_upper_bound");
        op.add(Builder::key, JsonpDeserializer.arrayDeserializer(FieldValue._DESERIALIZER), "key");
        op.add(Builder::keyAsString, JsonpDeserializer.stringDeserializer(), "key_as_string");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.docCountErrorUpperBound);
        result = 31 * result + this.key.hashCode();
        result = 31 * result + Objects.hashCode(this.keyAsString);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiTermsBucket other = (MultiTermsBucket)o;
        return Objects.equals(this.docCountErrorUpperBound, other.docCountErrorUpperBound) && this.key.equals(other.key) && Objects.equals(this.keyAsString, other.keyAsString);
    }

    public static class Builder
    extends MultiBucketBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, MultiTermsBucket> {
        @Nullable
        private Long docCountErrorUpperBound;
        private List<FieldValue> key;
        @Nullable
        private String keyAsString;

        public Builder() {
        }

        private Builder(MultiTermsBucket o) {
            super(o);
            this.docCountErrorUpperBound = o.docCountErrorUpperBound;
            this.key = Builder._listCopy(o.key);
            this.keyAsString = o.keyAsString;
        }

        private Builder(Builder o) {
            super(o);
            this.docCountErrorUpperBound = o.docCountErrorUpperBound;
            this.key = Builder._listCopy(o.key);
            this.keyAsString = o.keyAsString;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder docCountErrorUpperBound(@Nullable Long value) {
            this.docCountErrorUpperBound = value;
            return this;
        }

        @Nonnull
        public final Builder key(List<FieldValue> list) {
            this.key = Builder._listAddAll(this.key, list);
            return this;
        }

        @Nonnull
        public final Builder key(FieldValue value, FieldValue ... values) {
            this.key = Builder._listAdd(this.key, value, values);
            return this;
        }

        @Nonnull
        public final Builder key(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.key(fn.apply(new FieldValue.Builder()).build(), new FieldValue[0]);
        }

        @Nonnull
        public final Builder keyAsString(@Nullable String value) {
            this.keyAsString = value;
            return this;
        }

        @Override
        @Nonnull
        public MultiTermsBucket build() {
            this._checkSingleUse();
            return new MultiTermsBucket(this);
        }
    }
}

