/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.dialogs;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.e4.ui.dialogs.filteredtree.FilteredTree;
import org.eclipse.e4.ui.dialogs.filteredtree.PatternFilter;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.dialogs.StructuredIUGroup;
import org.eclipse.equinox.internal.p2.ui.model.InstalledIUElement;
import org.eclipse.equinox.internal.p2.ui.model.ProfileElement;
import org.eclipse.equinox.internal.p2.ui.viewers.DeferredQueryContentProvider;
import org.eclipse.equinox.internal.p2.ui.viewers.IUColumnConfig;
import org.eclipse.equinox.internal.p2.ui.viewers.IUComparator;
import org.eclipse.equinox.internal.p2.ui.viewers.IUDetailsLabelProvider;
import org.eclipse.equinox.internal.p2.ui.viewers.ProvElementComparer;
import org.eclipse.equinox.internal.p2.ui.viewers.StructuredViewerProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.ProvisioningListener;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class InstalledIUGroup
extends StructuredIUGroup {
    private String profileId;

    public InstalledIUGroup(ProvisioningUI ui, Composite parent, Font font, String profileId, IUColumnConfig[] columnConfig) {
        super(ui, parent, font, columnConfig);
        this.profileId = profileId == null ? ui.getProfileId() : profileId;
        this.createGroupComposite(parent);
    }

    @Override
    protected StructuredViewer createViewer(Composite parent) {
        FilteredTree filteredTree = new FilteredTree(parent, 68354, new PatternFilter());
        filteredTree.getFilterControl().setFocus();
        TreeViewer installedIUViewer = filteredTree.getViewer();
        IUComparator comparator = new IUComparator(0);
        comparator.useColumnConfig(this.getColumnConfig());
        installedIUViewer.setComparator((ViewerComparator)comparator);
        installedIUViewer.setComparer((IElementComparer)new ProvElementComparer());
        installedIUViewer.setContentProvider((IContentProvider)new DeferredQueryContentProvider(){
            private final Map<Object, Object[]> elementChildren = new HashMap<Object, Object[]>();
            private final Map<IInstallableUnit, Set<IInstallableUnit>> iuChildren = new HashMap<IInstallableUnit, Set<IInstallableUnit>>();

            @Override
            public boolean hasChildren(Object element) {
                return this.getChildren(element).length != 0;
            }

            @Override
            public Object[] getChildren(Object element) {
                Object[] objects = this.elementChildren.get(element);
                if (objects == null) {
                    Set<IInstallableUnit> children;
                    IInstallableUnit iu;
                    if (element instanceof InstalledIUElement) {
                        InstalledIUElement installedIUElement = (InstalledIUElement)element;
                        if (!installedIUElement.shouldShowChildren()) {
                            objects = new Object[]{};
                            this.elementChildren.put(element, objects);
                            return objects;
                        }
                        String localProfileId = installedIUElement.getProfileId();
                        iu = installedIUElement.getIU();
                        children = this.iuChildren.get(iu);
                        if (children != null) {
                            LinkedHashSet<InstalledIUElement> elementIUChildren = new LinkedHashSet<InstalledIUElement>();
                            for (IInstallableUnit childIU : children) {
                                elementIUChildren.add(new InstalledIUElement(element, localProfileId, childIU));
                            }
                            objects = elementIUChildren.toArray();
                            this.elementChildren.put(element, objects);
                            return objects;
                        }
                    }
                    objects = super.getChildren(element);
                    this.elementChildren.put(element, objects);
                    if (objects.length != 0 && element instanceof InstalledIUElement) {
                        InstalledIUElement installedIUElement = (InstalledIUElement)element;
                        iu = installedIUElement.getIU();
                        children = new LinkedHashSet<IInstallableUnit>();
                        Object[] objectArray = objects;
                        int n = objects.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object object = objectArray[n2];
                            if (!(object instanceof InstalledIUElement)) {
                                return objects;
                            }
                            InstalledIUElement childInstalledIUElement = (InstalledIUElement)object;
                            IInstallableUnit childIU = childInstalledIUElement.getIU();
                            children.add(childIU);
                            ++n2;
                        }
                        this.iuChildren.put(iu, children);
                    }
                }
                return objects;
            }
        });
        this.setTreeColumns(installedIUViewer.getTree());
        installedIUViewer.setLabelProvider((IBaseLabelProvider)new IUDetailsLabelProvider(null, this.getColumnConfig(), null));
        installedIUViewer.setInput(this.getInput());
        StructuredViewerProvisioningListener listener = new StructuredViewerProvisioningListener(this.getClass().getName(), (StructuredViewer)installedIUViewer, 6, this.getProvisioningUI().getOperationRunner());
        ProvUI.getProvisioningEventBus(this.getProvisioningUI().getSession()).addListener((ProvisioningListener)listener);
        installedIUViewer.getControl().addDisposeListener(e -> ProvUI.getProvisioningEventBus(this.getProvisioningUI().getSession()).removeListener((ProvisioningListener)listener));
        return installedIUViewer;
    }

    private void setTreeColumns(Tree tree) {
        IUColumnConfig[] columns = this.getColumnConfig();
        tree.setHeaderVisible(true);
        int i = 0;
        while (i < columns.length) {
            TreeColumn tc = new TreeColumn(tree, 0, i);
            tc.setResizable(true);
            tc.setText(columns[i].getColumnTitle());
            tc.setWidth(columns[i].getWidthInPixels((Control)tree));
            ++i;
        }
    }

    Object getInput() {
        ProfileElement element = new ProfileElement(null, this.profileId);
        return element;
    }

    @Override
    public StructuredViewer getStructuredViewer() {
        return super.getStructuredViewer();
    }

    @Override
    public Control getDefaultFocusControl() {
        return super.getDefaultFocusControl();
    }
}

