/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class TempMethodInvocator<R> {
    private Method myMethod;
    private Constructor<?> myCtor;

    public TempMethodInvocator(String clsFQN, String method, Class<?> ... parameterTypes) {
        try {
            Class<?> cls = Class.forName(clsFQN);
            this.myMethod = cls.getDeclaredMethod(method, parameterTypes);
            if (!this.myMethod.isAccessible()) {
                this.myMethod.setAccessible(true);
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
    }

    public TempMethodInvocator(String clsFQN, Class<?> ... parameterTypes) {
        try {
            Class<?> cls = Class.forName(clsFQN);
            this.myCtor = cls.getDeclaredConstructor(parameterTypes);
            if (!this.myCtor.isAccessible()) {
                this.myCtor.setAccessible(true);
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
    }

    public R invoke(Object object, Object ... arguments) {
        if (this.myMethod == null) {
            throw new IllegalStateException("Method is not available");
        }
        try {
            Object res2 = this.myMethod.invoke(object, arguments);
            return (R)(res2 != null ? res2 : null);
        }
        catch (IllegalAccessException | InvocationTargetException e2) {
            throw new RuntimeException(e2);
        }
    }

    public R staticInvoke(Object ... arguments) {
        return this.invoke(null, arguments);
    }

    public R create(Object ... args) {
        if (this.myCtor == null) {
            throw new IllegalStateException("Ctor is not available");
        }
        try {
            return (R)this.myCtor.newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e2) {
            throw new RuntimeException(e2);
        }
    }
}

