/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.lock;

import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.EventAction;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.lock.LockClient;

public class CmdLockClient
extends BaseSvnClient
implements LockClient {
    @Override
    public void lock(@NotNull File file, boolean force, @NotNull String message, @Nullable ProgressTracker handler) throws VcsException {
        if (file == null) {
            CmdLockClient.$$$reportNull$$$0(0);
        }
        if (message == null) {
            CmdLockClient.$$$reportNull$$$0(1);
        }
        List<String> parameters = CmdLockClient.prepareParameters(file, force);
        parameters.add("--message");
        parameters.add(message);
        CommandExecutor command = this.execute(this.myVcs, Target.on(file), SvnCommandName.lock, parameters, null);
        CmdLockClient.handleCommandCompletion(command, file, EventAction.LOCKED, EventAction.LOCK_FAILED, handler);
    }

    @Override
    public void unlock(@NotNull File file, boolean force, @Nullable ProgressTracker handler) throws VcsException {
        if (file == null) {
            CmdLockClient.$$$reportNull$$$0(2);
        }
        List<String> parameters = CmdLockClient.prepareParameters(file, force);
        CommandExecutor command = this.execute(this.myVcs, Target.on(file), SvnCommandName.unlock, parameters, null);
        CmdLockClient.handleCommandCompletion(command, file, EventAction.UNLOCKED, EventAction.UNLOCK_FAILED, handler);
    }

    private static List<String> prepareParameters(@NotNull File file, boolean force) {
        if (file == null) {
            CmdLockClient.$$$reportNull$$$0(3);
        }
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, file);
        CommandUtil.put(parameters, force, "--force");
        return parameters;
    }

    private static void handleCommandCompletion(@NotNull CommandExecutor command, @NotNull File file, @NotNull EventAction success, @NotNull EventAction failure, @Nullable ProgressTracker handler) throws VcsException {
        String error;
        if (command == null) {
            CmdLockClient.$$$reportNull$$$0(4);
        }
        if (file == null) {
            CmdLockClient.$$$reportNull$$$0(5);
        }
        if (success == null) {
            CmdLockClient.$$$reportNull$$$0(6);
        }
        if (failure == null) {
            CmdLockClient.$$$reportNull$$$0(7);
        }
        CmdLockClient.callHandler(handler, CmdLockClient.createEvent(file, (error = SvnUtil.parseWarning(command.getErrorOutput())) == null ? success : failure, error));
    }

    @NotNull
    private static ProgressEvent createEvent(@NotNull File file, @NotNull EventAction action, @Nullable String error) {
        if (file == null) {
            CmdLockClient.$$$reportNull$$$0(8);
        }
        if (action == null) {
            CmdLockClient.$$$reportNull$$$0(9);
        }
        return new ProgressEvent(file, -1L, null, null, action, error, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "success";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failure";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/lock/CmdLockClient";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "lock";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "unlock";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareParameters";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "handleCommandCompletion";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createEvent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

